package furny;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

import furny.entities.Furniture;
import furny.furndb.FurnCache;
import furny.ga.FurnEntry;
import furny.ga.FurnLayoutIndividual;
import furny.ga.PseudoSpace;
import furny.ga.RoomVector;
import furny.ga.util.Distance;
import furny.ga.util.FurnLayoutIOUtil;
import ga.core.GA;
import ga.core.validation.GAContext;

public class DistanceSortedList extends ArrayList<FurnLayoutIndividual> {
  public DistanceSortedList(final List<FurnLayoutIndividual> list,
      final GAContext context) {
    if (list.size() > 0) {

      final List<FurnLayoutIndividual> list2 = this;

      final List<FurnLayoutIndividual> l = new ArrayList<FurnLayoutIndividual>(
          list);

      list2.add(l.remove(0));

      if (l.size() > 0) {
        FurnLayoutIndividual last = list2.get(0);
        FurnLayoutIndividual nearest = null;
        float lowestDist;

        while (!l.isEmpty()) {
          lowestDist = Float.MAX_VALUE;

          final Iterator<FurnLayoutIndividual> it = l.iterator();
          while (it.hasNext()) {
            final FurnLayoutIndividual act = it.next();

            final float dist = Distance.calcDistance2(last, act, context);

            if (dist < lowestDist) {
              lowestDist = dist;
              nearest = act;
            }
          }

          l.remove(nearest);
          list2.add(nearest);
          last = nearest;
        }
      }
    }
  }

  public static void main(final String[] args) {
    final float width = 10f;
    final float length = 10f;

    Logger.getLogger("").setLevel(Level.FINE);

    final GAContext context = new GAContext();
    context.put(GA.KEY_VALIDATION_SPACE, new PseudoSpace(width, length));

    final List<Furniture> all = FurnCache.getInstance().getAllFurnitures();

    final FurnLayoutIndividual ind1 = new FurnLayoutIndividual(context);
    ind1.getFurnitures().add(
        new FurnEntry(new RoomVector(-500, -500, 3), all.get(1)));

    final FurnLayoutIndividual ind2 = new FurnLayoutIndividual(context);
    ind2.getFurnitures().add(
        new FurnEntry(new RoomVector(500, 500, 3), all.get(1)));
    ind2.getFurnitures().add(
        new FurnEntry(new RoomVector(100, 100, 2), all.get(0)));

    final FurnLayoutIndividual ind3 = new FurnLayoutIndividual(context);
    ind3.getFurnitures().add(
        new FurnEntry(new RoomVector(100, 0, 0), all.get(4)));
    ind3.getFurnitures().add(
        new FurnEntry(new RoomVector(500, 500, 0), all.get(4)));

    final FurnLayoutIndividual ind4 = new FurnLayoutIndividual(context);
    ind4.getFurnitures().add(
        new FurnEntry(new RoomVector(300, 200, 0), all.get(1)));
    ind4.getFurnitures().add(
        new FurnEntry(new RoomVector(-200, -100, 0), all.get(0)));

    final List<FurnLayoutIndividual> l1 = new ArrayList<FurnLayoutIndividual>();

    l1.add(ind1);
    l1.add(ind2);
    l1.add(ind3);
    l1.add(ind4);

    FurnLayoutIOUtil.printGenotypes(l1);
    System.err.println();

    final DistanceSortedList l2 = new DistanceSortedList(l1, context);

    FurnLayoutIOUtil.printGenotypes(l2);
    System.err.println();

    Collections.sort(l1, new Comparator<FurnLayoutIndividual>() {
      @Override
      public int compare(final FurnLayoutIndividual ind1,
          final FurnLayoutIndividual ind2) {
        return (int) (10f * Distance.calcDistance2(ind1, ind2, context) - 5f);
      }
    });

    System.out.println(FurnLayoutIOUtil.printGenotypes(l1));
  }
}
